/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.primitives.Longs;
import java.util.Comparator;
import javax.annotation.Nullable;

public abstract class ComparisonChain {
    private static final ComparisonChain ACTIVE = new ComparisonChain(){

        @Override
        public <T> ComparisonChain compare(@Nullable T left, @Nullable T right, Comparator<T> comparator) {
            return this.classify(comparator.compare(left, right));
        }

        @Override
        public ComparisonChain compare(long left, long right) {
            return this.classify(Longs.compare(left, right));
        }

        ComparisonChain classify(int result) {
            return result < 0 ? LESS : (result > 0 ? GREATER : ACTIVE);
        }

        @Override
        public int result() {
            return 0;
        }
    };
    private static final ComparisonChain LESS = new InactiveComparisonChain(-1);
    private static final ComparisonChain GREATER = new InactiveComparisonChain(1);

    private ComparisonChain() {
    }

    public static ComparisonChain start() {
        return ACTIVE;
    }

    public abstract <T> ComparisonChain compare(@Nullable T var1, @Nullable T var2, Comparator<T> var3);

    public abstract ComparisonChain compare(long var1, long var3);

    public abstract int result();

    private static final class InactiveComparisonChain
    extends ComparisonChain {
        final int result;

        InactiveComparisonChain(int result) {
            this.result = result;
        }

        @Override
        public <T> ComparisonChain compare(@Nullable T left, @Nullable T right, @Nullable Comparator<T> comparator) {
            return this;
        }

        @Override
        public ComparisonChain compare(long left, long right) {
            return this;
        }

        @Override
        public int result() {
            return this.result;
        }
    }
}

