/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.zip.DeflaterInputStream;
import java.util.zip.InflaterInputStream;
import org.iq80.leveldb.util.Snappy;

public class Zlib {
    private static final Snappy.SPI ZLIB = new ZLibSPI();

    private Zlib() {
    }

    public static boolean available() {
        return ZLIB != null;
    }

    public static void uncompress(ByteBuffer compressed, ByteBuffer uncompressed) throws IOException {
        ZLIB.uncompress(compressed, uncompressed);
    }

    public static void uncompress(byte[] input, int inputOffset, int length, byte[] output, int outputOffset) throws IOException {
        ZLIB.uncompress(input, inputOffset, length, output, outputOffset);
    }

    public static int compress(byte[] input, int inputOffset, int length, byte[] output, int outputOffset) throws IOException {
        return ZLIB.compress(input, inputOffset, length, output, outputOffset);
    }

    public static byte[] compress(String text) throws IOException {
        return ZLIB.compress(text);
    }

    private static class ZLibSPI
    implements Snappy.SPI {
        private ZLibSPI() {
        }

        private int copy(InputStream in, OutputStream out) throws IOException {
            int read;
            byte[] buffer = new byte[1024];
            int count = 0;
            while (-1 != (read = in.read(buffer))) {
                out.write(buffer, 0, read);
                count += read;
            }
            return count;
        }

        @Override
        public int uncompress(ByteBuffer compressed, ByteBuffer uncompressed) throws IOException {
            int count = this.copy(new InflaterInputStream(new ByteBufferBackedInputStream(compressed)), new ByteBufferBackedOutputStream(uncompressed));
            uncompressed.flip();
            return count;
        }

        @Override
        public int uncompress(byte[] input, int inputOffset, int length, byte[] output, int outputOffset) throws IOException {
            return this.copy(new InflaterInputStream(new ByteArrayInputStream(input, inputOffset, length)), new ByteBufferBackedOutputStream(ByteBuffer.wrap(output, outputOffset, output.length - outputOffset)));
        }

        @Override
        public int compress(byte[] input, int inputOffset, int length, byte[] output, int outputOffset) throws IOException {
            return this.copy(new DeflaterInputStream(new ByteArrayInputStream(input, inputOffset, length)), new ByteBufferBackedOutputStream(ByteBuffer.wrap(output, outputOffset, output.length - outputOffset)));
        }

        @Override
        public byte[] compress(String text) throws IOException {
            byte[] input = text.getBytes();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.copy(new DeflaterInputStream(new ByteArrayInputStream(input, 0, input.length)), baos);
            return baos.toByteArray();
        }

        @Override
        public int maxCompressedLength(int length) {
            return 0;
        }
    }

    public static class ByteBufferBackedOutputStream
    extends OutputStream {
        ByteBuffer buf;

        public ByteBufferBackedOutputStream(ByteBuffer buf) {
            this.buf = buf;
        }

        @Override
        public void write(int b) throws IOException {
            this.buf.put((byte)b);
        }

        @Override
        public void write(byte[] bytes, int off, int len) throws IOException {
            this.buf.put(bytes, off, len);
        }
    }

    public static class ByteBufferBackedInputStream
    extends InputStream {
        ByteBuffer buf;

        public ByteBufferBackedInputStream(ByteBuffer buf) {
            this.buf = buf;
        }

        @Override
        public int read() throws IOException {
            if (!this.buf.hasRemaining()) {
                return -1;
            }
            return this.buf.get() & 0xFF;
        }

        @Override
        public int read(byte[] bytes, int off, int len) throws IOException {
            if (!this.buf.hasRemaining()) {
                return -1;
            }
            len = Math.min(len, this.buf.remaining());
            this.buf.get(bytes, off, len);
            return len;
        }
    }
}

